/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.world.event;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2378;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_32;
import net.minecraft.class_5218;
import net.minecraft.class_5285;
import net.minecraft.class_5292;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7145;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.config.Configs;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.betterx.worlds.together.mixin.common.RegistryOpsAccessor;
import org.betterx.worlds.together.mixin.common.WorldPresetAccessor;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleUtil;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.world.event.OnWorldLoad;
import org.betterx.worlds.together.world.event.WorldEventsImpl;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;
import org.betterx.worlds.together.worldPreset.WorldGenSettingsComponentAccessor;
import org.betterx.worlds.together.worldPreset.WorldPresets;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class WorldBootstrap {
    private static class_5455 LAST_REGISTRY_ACCESS = null;

    public static class_5455 getLastRegistryAccess() {
        return LAST_REGISTRY_ACCESS;
    }

    public static class_5455 getLastRegistryAccessOrElseBuiltin() {
        if (LAST_REGISTRY_ACCESS == null) {
            return class_5458.field_36476;
        }
        return LAST_REGISTRY_ACCESS;
    }

    public static void finalizeWorldGenSettings(class_5285 worldGenSettings) {
        Object output = "World Dimensions: ";
        for (Map.Entry entry : worldGenSettings.method_28609().method_29722()) {
            WorldEventsImpl.ON_FINALIZE_LEVEL_STEM.emit(e -> e.now(worldGenSettings, (class_5321<class_5363>)((class_5321)entry.getKey()), (class_5363)entry.getValue()));
            if (!Configs.MAIN_CONFIG.verboseLogging()) continue;
            output = (String)output + "\n - " + ((class_5321)entry.getKey()).method_29177().toString() + ": \n     " + ((class_5363)entry.getValue()).method_29571().toString() + " " + ((class_5363)entry.getValue()).method_29571().method_12098().toString().replace("\n", "\n     ");
        }
        if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info((String)output);
        }
        SurfaceRuleUtil.injectSurfaceRulesToAllDimensions(worldGenSettings);
        WorldEventsImpl.ON_FINALIZED_WORLD_LOAD.emit(e -> e.done(worldGenSettings));
    }

    public static class_5285 enforceInNewWorld(class_5285 worldGenSettings) {
        return WorldGenUtil.repairBiomeSourceInAllDimensions(LAST_REGISTRY_ACCESS, worldGenSettings);
    }

    public static class_5285 enforceInLoadedWorld(Optional<class_6903<class_2520>> registryOps, class_5285 worldGenSettings) {
        Object var3_2 = registryOps.orElse(null);
        if (var3_2 instanceof RegistryOpsAccessor) {
            RegistryOpsAccessor acc = var3_2;
            return WorldGenUtil.repairBiomeSourceInAllDimensions(acc.bcl_getRegistryAccess(), worldGenSettings);
        }
        WorldsTogether.LOGGER.error("Unable to obtain registryAccess when enforcing generators.");
        return worldGenSettings;
    }

    public static class InFreshLevel {
        public static void setupNewWorld(String levelID, class_5285 worldGenSettings, class_32 levelSource, Optional<class_6880<class_7145>> worldPreset) {
            try {
                class_32.class_5143 levelStorageAccess = levelSource.method_27002(levelID);
                InGUI.setupNewWorldCommon(levelStorageAccess, worldPreset, worldGenSettings);
                levelStorageAccess.close();
            }
            catch (Exception e) {
                WorldsTogether.LOGGER.error("Failed to initialize data in world", e);
            }
        }
    }

    public static class InGUI {
        public static void registryReadyOnNewWorld(class_5292 worldGenSettingsComponent) {
            Helpers.onRegistryReady(worldGenSettingsComponent.method_29700());
        }

        public static void registryReadyOnLoadedWorld(Optional<class_6903<class_2520>> registryOps) {
            Object var2_1 = registryOps.orElse(null);
            if (var2_1 instanceof RegistryOpsAccessor) {
                RegistryOpsAccessor acc = var2_1;
                Helpers.onRegistryReady(acc.bcl_getRegistryAccess());
            }
        }

        public static void registryReady(class_5455 access) {
            Helpers.onRegistryReady(access);
        }

        public static void setupNewWorld(Optional<class_32.class_5143> levelStorageAccess, class_5292 worldGenSettingsComponent) {
            if (levelStorageAccess.isPresent()) {
                if (worldGenSettingsComponent instanceof WorldGenSettingsComponentAccessor) {
                    WorldGenSettingsComponentAccessor acc = (WorldGenSettingsComponentAccessor)worldGenSettingsComponent;
                    Optional<class_6880<class_7145>> currentPreset = acc.bcl_getPreset();
                    currentPreset = Helpers.presetFromDatapack(currentPreset);
                    Optional<class_6880<class_7145>> newPreset = InGUI.setupNewWorldCommon(levelStorageAccess.get(), currentPreset, worldGenSettingsComponent.method_41884().comp_616());
                    if (newPreset != currentPreset) {
                        acc.bcl_setPreset(newPreset);
                    }
                } else {
                    WorldsTogether.LOGGER.error("Unable to access WorldGenSettingsComponent.");
                }
            } else {
                WorldsTogether.LOGGER.error("Unable to access Level Folder.");
            }
        }

        static Optional<class_6880<class_7145>> setupNewWorldCommon(class_32.class_5143 levelStorageAccess, Optional<class_6880<class_7145>> currentPreset, class_5285 worldGenSettings) {
            Map<class_5321<class_5363>, class_2794> dimensions;
            Helpers.initializeWorldConfig(levelStorageAccess, true);
            Object var5_3 = currentPreset.map(class_6880::comp_349).orElse(null);
            if (var5_3 instanceof TogetherWorldPreset) {
                TogetherWorldPreset t = var5_3;
                dimensions = t.getDimensionsMap();
            } else {
                dimensions = TogetherWorldPreset.getDimensionsMap((class_5321<class_7145>)class_5317.field_25050);
            }
            WorldEventsImpl.BEFORE_WORLD_LOAD.emit(e -> e.prepareWorld(levelStorageAccess, dimensions, true));
            currentPreset = WorldEventsImpl.ADAPT_WORLD_PRESET.emit(currentPreset, worldGenSettings);
            var5_3 = currentPreset.map(class_6880::comp_349).orElse(null);
            if (var5_3 instanceof WorldPresetAccessor) {
                WorldPresetAccessor acc = var5_3;
                TogetherWorldPreset.writeWorldPresetSettings(acc.bcl_getDimensions());
            } else {
                WorldsTogether.LOGGER.error("Failed writing together File");
                TogetherWorldPreset.writeWorldPresetSettings((class_2378<class_5363>)worldGenSettings.method_28609());
            }
            WorldEventsImpl.ON_WORLD_LOAD.emit(OnWorldLoad::onLoad);
            return currentPreset;
        }

        public static void setupLoadedWorld(String levelID, class_32 levelSource) {
            WorldGenUtil.clearPreloadedWorldPresets();
            try {
                class_32.class_5143 levelStorageAccess = levelSource.method_27002(levelID);
                try {
                    Helpers.initializeWorldConfig(levelStorageAccess, false);
                    WorldEventsImpl.BEFORE_WORLD_LOAD.emit(e -> e.prepareWorld(levelStorageAccess, TogetherWorldPreset.loadWorldDimensions(), false));
                }
                catch (Exception e2) {
                    WorldsTogether.LOGGER.error("Failed to initialize data in world", e2);
                }
                levelStorageAccess.close();
            }
            catch (Exception e3) {
                WorldsTogether.LOGGER.error("Failed to acquire storage access", e3);
            }
        }

        public static boolean applyWorldPatches(class_32 levelSource, String levelID, Consumer<Boolean> onResume) {
            boolean result = false;
            try {
                class_32.class_5143 levelStorageAccess = levelSource.method_27002(levelID);
                result = WorldEventsImpl.PATCH_WORLD.applyPatches(levelStorageAccess, onResume);
                levelStorageAccess.close();
            }
            catch (Exception e) {
                WorldsTogether.LOGGER.error("Failed to initialize data in world", e);
            }
            return result;
        }

        public static void finishedWorldLoad(String levelID, class_32 levelSource) {
            WorldEventsImpl.ON_WORLD_LOAD.emit(OnWorldLoad::onLoad);
            WorldGenUtil.clearPreloadedWorldPresets();
        }
    }

    public static class DedicatedServer {
        public static void registryReady(class_6903<class_2520> regOps) {
            if (regOps instanceof RegistryOpsAccessor) {
                RegistryOpsAccessor acc = (RegistryOpsAccessor)regOps;
                Helpers.onRegistryReady(acc.bcl_getRegistryAccess());
            }
        }

        public static void setupWorld(class_32.class_5143 levelStorageAccess) {
            File levelDat = levelStorageAccess.method_27010(class_5218.field_24184).toFile();
            if (!levelDat.exists()) {
                WorldsTogether.LOGGER.info("Creating a new World, no fixes needed");
                Map<class_5321<class_5363>, class_2794> settings = Helpers.defaultServerDimensions();
                Helpers.initializeWorldConfig(levelStorageAccess, true);
                WorldEventsImpl.BEFORE_SERVER_WORLD_LOAD.emit(e -> e.prepareWorld(levelStorageAccess, settings, true));
            } else {
                Helpers.initializeWorldConfig(levelStorageAccess, false);
                WorldEventsImpl.BEFORE_SERVER_WORLD_LOAD.emit(e -> e.prepareWorld(levelStorageAccess, TogetherWorldPreset.loadWorldDimensions(), false));
                WorldEventsImpl.ON_WORLD_LOAD.emit(OnWorldLoad::onLoad);
            }
        }

        public static void applyDatapackChangesOnNewWorld(class_5285 worldGenSettings) {
            Optional<class_6880<class_7145>> currentPreset = Optional.of(Helpers.defaultServerPreset());
            Object var3_2 = (currentPreset = WorldEventsImpl.ADAPT_WORLD_PRESET.emit(currentPreset, worldGenSettings)).map(class_6880::comp_349).orElse(null);
            if (var3_2 instanceof WorldPresetAccessor) {
                WorldPresetAccessor acc = var3_2;
                TogetherWorldPreset.writeWorldPresetSettings(acc.bcl_getDimensions());
            } else {
                WorldsTogether.LOGGER.error("Failed writing together File");
                TogetherWorldPreset.writeWorldPresetSettings((class_2378<class_5363>)worldGenSettings.method_28609());
            }
            WorldEventsImpl.ON_WORLD_LOAD.emit(OnWorldLoad::onLoad);
        }
    }

    public static class Helpers {
        private static void initializeWorldConfig(class_32.class_5143 levelStorageAccess, boolean newWorld) {
            File levelPath = levelStorageAccess.method_27010(class_5218.field_24188).toFile();
            Helpers.initializeWorldConfig(levelPath, newWorld);
        }

        private static void initializeWorldConfig(File levelBaseDir, boolean newWorld) {
            WorldConfig.load(new File(levelBaseDir, "data"));
        }

        private static void onRegistryReady(class_5455 a) {
            if (a != LAST_REGISTRY_ACCESS) {
                LAST_REGISTRY_ACCESS = a;
                WorldEventsImpl.WORLD_REGISTRY_READY.emit(e -> e.initRegistry(a));
            }
        }

        private static class_6880<class_7145> defaultServerPreset() {
            return WorldPresets.get(LAST_REGISTRY_ACCESS, WorldPresets.getDEFAULT());
        }

        private static Map<class_5321<class_5363>, class_2794> defaultServerDimensions() {
            class_6880<class_7145> defaultPreset = Helpers.defaultServerPreset();
            return Helpers.defaultServerDimensions(defaultPreset);
        }

        private static Map<class_5321<class_5363>, class_2794> defaultServerDimensions(class_6880<class_7145> defaultPreset) {
            Map<class_5321<class_5363>, class_2794> dimensions;
            Object object = defaultPreset.comp_349();
            if (object instanceof TogetherWorldPreset) {
                TogetherWorldPreset t = (TogetherWorldPreset)((Object)object);
                dimensions = t.getDimensionsMap();
            } else {
                dimensions = TogetherWorldPreset.getDimensionsMap((class_5321<class_7145>)class_5317.field_25050);
            }
            return dimensions;
        }

        private static Optional<class_6880<class_7145>> presetFromDatapack(Optional<class_6880<class_7145>> currentPreset) {
            Optional newPreset;
            Optional presetKey;
            if (currentPreset.isPresent() && LAST_REGISTRY_ACCESS != null && (presetKey = currentPreset.get().method_40230()).isPresent() && (newPreset = LAST_REGISTRY_ACCESS.method_30530(class_2378.field_37998).method_40264((class_5321)presetKey.get())).isPresent()) {
                currentPreset = newPreset;
            }
            return currentPreset;
        }
    }
}

